<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;

/**
 * Link field mapper
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "link_mapping",
 *   label = @Translation("Link Mapping"),
 *   entity_field_types = {"link"},
 * )
 */
class LinkMapping extends FieldMappingBase {

  public function getSupportedWebformFields($webform_id) {
    $supported_types = ["url"];

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

    $content->set($fieldId, $fieldValue);
  }

}
