<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;
use Drupal\webform_content_creator\Plugin\FieldMappingInterface;

/**
 * Mapper for entity reference fields.
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "entity_reference_mapping",
 *   label = @Translation("Entity Reference Mapping"),
 *   entity_field_types = {"entity_reference", "entity_reference_revision"},
 * )
 */
class EntityReferenceMapping extends FieldMappingBase {

  public function supportsCustomFields() {
    return FALSE;
  }

  public function getSupportedWebformFields($webform_id) {
    $supported_types = array_merge(['entity_reference'], FieldMappingInterface::WEBFORM_ENTIY_REFERENCE_ELEMENTS);

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

    if (!is_array($fieldValue) && intval($fieldValue) === 0) {
      $content->set($fieldId, []);
    }
    else {
      $content->set($fieldId, $fieldValue);
    }
  }

}
