<?php

namespace Drupal\webform_content_creator\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines the webform content creator mapping annotation object.
 *
 * Plugin namespace: Plugin\WebformContentCreator\FieldMapping.
 *
 * @see plugin_api
 *
 * @Annotation
 */
class WebformContentCreatorFieldMapping extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The plugin label.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The entity type field types supported
   *
   * @var array
   */
  public $entity_field_types;

}
