/**
 * @file
 * Defines the behavior of the webform content creator configuration page.
 */

(function ($, Drupal) {

  'use strict';

  /**
   * Attaches the behavior of the webform content creator configuration page
   * to manage fields.
   */
  Drupal.behaviors.webformContentCreator = {

    attach: function (context) {

      /**
       * Handler to enable/disable fields depending on the first checkbox
       * value.
       */
      function validateContentType(element) {
        if (!element) {
          return;
        }
        var n = element.id.lastIndexOf('-content-type-field');
        if (!n) {
          return;
        }
        var row = $(element).parents('tr');
        $(row).find('[id^="' + row.attr('data-drupal-selector').concat('-webform-field') + '"]').each(function (index, value) {
          var customValue = value.id.replace('-webform-field', '-custom-value');
          var customCheck = value.id.replace('-webform-field', '-custom-check');
          if (element.checked) {
            $('#'.concat(value.id)).prop("disabled", false);
            $(row).find('[name*="[custom_check]"]').each(function () {
              validateCustomCheck(this);
            });
          }
          else {
            $('#'.concat(value.id)).prop("disabled", true);
            if (customValue) {
              $('#'.concat(customValue)).prop("disabled", true);
              $('#'.concat(customValue)).addClass("webform-content-creator disabled");
              $('#'.concat(customValue)).val("");
            }
            if (customCheck) {
              $('#'.concat(customCheck)).prop("checked", false);
            }
          }
        });

      }

      /**
       * Handler to enable/disable fields depending on the custom (checkbox)
       * value.
       */
      function validateCustomCheck(element) {
        if (!element) {
          return;
        }

        var n = element.id.lastIndexOf('-custom-check');
        if (!n) {
          return;
        }
        var webformField = element.id.replace('-custom-check', '-webform-field');
        var customValue = element.id.replace('-custom-check', '-custom-value');

        if (element.checked) {
          if (webformField) {
            $('#'.concat(webformField)).prop('disabled', true);
          }
          if (customValue) {
            $('#'.concat(customValue)).prop('disabled', false);
            $('#'.concat(customValue)).removeClass('webform-content-creator disabled');
          }
        }
        else {
          if (webformField) {
            $('#'.concat(webformField)).prop('disabled', false);
          }
          if (customValue) {
            $('#'.concat(customValue)).prop('disabled', true);
            $('#'.concat(customValue)).addClass('webform-content-creator disabled');
          }
        }
      }

      $('[name$="[content_type_field]"]').each(function () {
        validateContentType(this);
      });

      $('[name$="[content_type_field]"]').click(function () {
        validateContentType(this);
      });

      $('[name*="[custom_check]"]').click(function () {
        validateCustomCheck(this);
      });
    }
  };

})(jQuery, Drupal);
