<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;
use Drupal\webform_content_creator\Plugin\FieldMappingInterface;

/**
 * Mapper for entity reference fields.
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "social_media_links_mapping",
 *   label = @Translation("Entity Reference Mapping"),
 *   entity_field_types = {"social_media_links_field"},
 * )
 */
class SocialMediaLinksMapping extends FieldMappingBase {

  public function getEntityComponentFields(FieldDefinitionInterface $field_definition) {
    $platforms = $field_definition->getSetting("platforms");
    $available_platforms = [];
    foreach ($platforms as $key => $platform) {
      if ($platform['enabled'] == 1) {
        $available_platforms[] = $key;
      }
    }

    return $available_platforms;
  }

  public function getSupportedWebformFields($webform_id) {
    $supported_types = FieldMappingInterface::WEBFORM_TEXT_ELEMENTS;

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldData = [];
    $fieldId = $field_definition->getName();
    foreach ($data as $key => $decValue) {
      $fieldData[$key] = [
        'value' => $decValue,
      ];
    }
    $content->set($fieldId, ['platform_values' => $fieldData]);
  }

}
