<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;
use Drupal\webform_content_creator\Plugin\FieldMappingInterface;

/**
 * Numeric field mapper
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "numeric_mapping",
 *   label = @Translation("Numeric Mapping"),
 *   entity_field_types = {"decimal", "float", "integer", "list_float", "list_integer"},
 * )
 */
class NumericMapping extends FieldMappingBase {

  public function getSupportedWebformFields($webform_id) {
    $supported_types = array_merge(["integer", "number", "range", "webform_scale"], FieldMappingInterface::WEBFORM_OPTIONS_ELEMENTS);

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

    $content->set($fieldId, $fieldValue);
  }

}
