<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;
use Drupal\webform_content_creator\WebformContentCreatorUtilities;

/**
 * Email field mapper
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "email_mapping",
 *   label = @Translation("Email Mapping"),
 *   entity_field_types = {"email"},
 * )
 */
class EmailMapping extends FieldMappingBase {

  public function getSupportedWebformFields($webform_id) {
    $supported_types = ["email", "webform_email_confirm"];

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

    $content->set($fieldId, $fieldValue);
  }

}
