<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;


/**
 * Text field mapper
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "boolean_mapping",
 *   label = @Translation("Boolean Mapping"),
 *   entity_field_types = {"boolean", "search_api_exclude_entity"},
 * )
 */
class BooleanMapping extends FieldMappingBase {

  public function getSupportedWebformFields($webform_id) {
    $supported_types = ["boolean", "checkbox"];

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

	  //Convert various strings (true, yes, on) to boolean
    if (!is_bool($fieldValue)) {
      $fieldValue = filter_var($fieldValue, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
    }
	
    if (isset($fieldValue)) {
      $content->set($fieldId, $fieldValue);
    }
  }

}
