<?php

namespace Drupal\webform_content_creator\Plugin\WebformContentCreator\FieldMapping;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\Plugin\FieldMappingBase;

/**
 * Address field mapper
 *
 * @WebformContentCreatorFieldMapping(
 *   id = "address_mapping",
 *   label = @Translation("Text Mapping"),
 *   entity_field_types = {"address"},
 * )
 */
class AddressMapping extends FieldMappingBase {

  public function supportsCustomFields() {
    return FALSE;
  }

  public function getSupportedWebformFields($webform_id) {
    $supported_types = ["address", "webform_address"];

    return $this->filterWebformFields($webform_id, $supported_types);
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $field_definition->getDefaultValue($content)[0];

    if ($webform_element[$fieldId]['#type'] == "webform_address") {
      if (!empty($data[$fieldId]['address'])) {
        $fieldValue['address_line1'] = $data[$fieldId]['address'];
      }
      if (!empty($data[$fieldId]['address_2'])) {
        $fieldValue['address_line2'] = $data[$fieldId]['address_2'];
      }
      if (!empty($data[$fieldId]['city'])) {
        $fieldValue['locality'] = $data[$fieldId]['city'];
      }
      if (!empty($data[$fieldId]['state_province'])) {
        $fieldValue['administrative_area'] = $data[$fieldId]['state_province'];
      }
      if (!empty($data[$fieldId]['postal_code'])) {
        $fieldValue['postal_code'] = $data[$fieldId]['postal_code'];
      }
      if (!empty($data[$fieldId]['country'])) {
        $fieldValue['country_code'] = $data[$fieldId]['country'];
      }
    }
    else {
      $fieldValue = array_merge($fieldValue, $data[$fieldId]);
    }

    $content->set($fieldId, $fieldValue);
  }

}
