<?php

namespace Drupal\webform_content_creator\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\webform_content_creator\Annotation\WebformContentCreatorFieldMapping;

/**
 * Provides a Webform Content Creator Field Mapping plugin manager.
 */
class FieldMappingPluginManager extends DefaultPluginManager {

  /**
   * Constructs a WebformContentMappingPlugin Manager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/WebformContentCreator/FieldMapping', $namespaces, $module_handler, FieldMappingInterface::class, WebformContentCreatorFieldMapping::class);
    $this->alterInfo('webform_content_creator_info');
    $this->setCacheBackend($cache_backend, 'webform_content_creator_info_plugins');
  }

  public function getPluginForEntityField(FieldDefinitionInterface $field_definiton) {
    $definitions = $this->getDefinitions();
    foreach ($definitions as $definition) {
      if (in_array($field_definiton->getType(), $definition['entity_field_types'])) {
        return $this->createInstance($definition['id']);
      }
    }

    return NULL;
  }

}
