<?php

namespace Drupal\webform_content_creator\Plugin;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\webform\WebformSubmissionInterface;
use Drupal\webform_content_creator\WebformContentCreatorUtilities;

class FieldMappingBase implements FieldMappingInterface {

  public function supportsCustomFields() {
    return TRUE;
  }

  public function getEntityComponentFields(FieldDefinitionInterface $field_definition) {
    return [];
  }

  public function getSupportedWebformFields($webform_id) {
    return WebformContentCreatorUtilities::getWebformElements($webform_id);;
  }

  public function mapEntityField(ContentEntityInterface &$content, array $webform_element, array $data = [], FieldDefinitionInterface $field_definition) {
    $fieldId = $field_definition->getName();
    $fieldValue = $data[$fieldId];

    $content->set($fieldId, $fieldValue);
  }

  protected function filterWebformFields($webform_id, array $supported_types, array $available_fields = NULL) {
    if (!isset($available_fields)) {
      $available_fields = WebformContentCreatorUtilities::getWebformElements($webform_id);
    }
    $webform_field_types = WebformContentCreatorUtilities::getWebformElementsTypes($webform_id);
    $allowed_fields = [];

    foreach ($available_fields as $key => $available_field) {
      $key_parts = explode(',', $key);
      if (sizeOf($key_parts) > 1) {
        $element_type = $webform_field_types[$key_parts[1]];
        //Webform field vs user added fields
        if ($key_parts[0] == "1") {
          $element_type = $element_type['type'];
        }
        if (in_array($element_type, $supported_types)) {
          $allowed_fields[$key] = $available_field;
        }
      }
      else {
        //We're dealing with an option group, so recursive call to process the sub fields
        $retval = $this->filterWebformFields($webform_id, $supported_types, $available_field);
        if (!empty($retval)) {
          $allowed_fields[$key] = $retval;
        }
      }
    }

    return $allowed_fields;
  }

}
