<?php
namespace Drupal\views_lunr_itemsjs\Controller;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultAllowed;
use Drupal\Core\Access\AccessResultNeutral;
use Drupal\Core\Cache\CacheableJsonResponse;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Render\RenderContext;
use Drupal\views_lunr_itemsjs\Entity\lunrItemsjs;
use Drupal\views_lunr_itemsjs\lunrItemsConfigInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

class LunrItemsjsIndexController extends ControllerBase {

  protected ?lunrItemsjs $lunrItemsjsConfig;

  public function __construct(ContainerInterface $container) {
    $this->container = $container;
  }

  public function json(string $lunr_itemsjs): CacheableJsonResponse|JsonResponse {
    $this->initLunrItemsjsConfig($lunr_itemsjs);
    $build = $this->buildInRenderContext();
    return $this->createResponse($build,
      $this->lunrItemsjsConfig->getDisplayType(),
      $this->lunrItemsjsConfig->getSettings()
    );
  }

  protected function initLunrItemsjsConfig(string $lunr_itemsjs): void {
    $this->lunrItemsjsConfig = $this->entityTypeManager()
      ->getStorage('lunr_itemsjs')
      ->load($lunr_itemsjs);
  }

  protected function buildInRenderContext() {
    $renderer = \Drupal::getContainer()->get('renderer');
    $context = new RenderContext();
    return $renderer->executeInRenderContext($context, function() {
      $view = $this->lunrItemsjsConfig->getViewExecutable();
      return $view->getDisplay()->execute();
    });
  }

  protected function createResponse(array $build, string $displayType, array $settings): CacheableJsonResponse {
    $response = new CacheableJsonResponse($build['#markup']);
    $cacheablity = CacheableMetadata::createFromRenderArray($build);
    if ($displayType === 'overview') {
      $cacheMaxAge = (int) ($settings['cache_max_age'] ?? 900);
      ($settings['cache_public'] ?? TRUE) ? $response->setPublic() : $response->setPrivate();
      if ($cacheMaxAge > 0) {
        $response->setMaxAge($cacheMaxAge);
        $cacheablity->setCacheMaxAge($cacheMaxAge);
      }
    }
    else {
      $response->setPrivate();
    }
    $response->addCacheableDependency($cacheablity);
    return $response;
  }

  public function access(string $lunr_itemsjs): AccessResultNeutral|AccessResult|AccessResultAllowed {
    $config = $this->entityTypeManager()
      ->getStorage('lunr_itemsjs')
      ->load($lunr_itemsjs);
    return AccessResult::allowedIf($config instanceof lunrItemsConfigInterface);
  }
}
