<?php

namespace Drupal\views_lunr_itemsjs\Plugin\views;

trait ExtractFromOptionsTrait {
  /**
   * Extracts a set of option values from a nested options array.
   *
   * @param string $key
   *   The key to extract from each array item.
   * @param array $options
   *   The options array to return values from.
   *
   * @return array
   *   A regular one dimensional array of values.
   */

  public static function extractFromOptionsArray(string $key, array $options): array {
    return array_map(static function ($item) use ($key) {
      return $item[$key] ?? NULL;
    }, $options);
  }
}
