function lunrSearch (settings) {
  this.documentSourceEndoint = settings.source;

  this.language = settings.language; // Fetch from DrupalSettings?

  // Lunr Searchable fields
  this.indexedFields = settings.indexed_fields;
  // Available sort options
  this.sorts = settings.sorts;
  this.indexPrimaryKey = settings.index_primary ?? '_itemsjs_id';

  // Item used for rendering results can be string or template
  this.listItem = settings.list_item;
  this.minChars = parseInt(settings.settings.min_chars)?? 3;
  this.boostField = (settings.settings.boosted_field !== '0' && settings.settings.boosted_field) ? settings.settings.boosted_field : false;
  this.targetPage = settings.target_page;
  /**
   * Maps the primary key to the original index
   * @type {*[]}
   */
  this.indexMap = [];
  /**
   * Loading state
   * @type {boolean}
   */
  this.isLoading = false;
  /**
   * Search is ready to search
   * @type {boolean}
   */
  this.isReady = false;
  /**
   * Search yielded results
   * @type {boolean}
   */
  this.hasResults = false;
  /**
   * Search has more then this.totalItems results
   * @type {boolean}
   */
  this.hasMoreResults = false;

  /**
   * Has load error?
   * @type {boolean}
   */
  this.hasError = false;

  /**
   * Max items to show
   * @type {number|*}
   */
  this.totalItems = settings.per_page;

  this.totalResults = 0;

  /**
   *  Indexable documents, loaded from the the documentSourceEndoint
   * @type {*[]}
   */
  this.documents = [];
  /**
   * Results for this page after a search has been performed.
   * @type { {} }
   */
  this.searchResults = {};

  /**
   * The query to search for.
   * @type {string}
   */
  this.searchQuery = '';

  /**
   * Bind for fully indexed Lunr
   * @type {lunr|{}}
   */
  this.lunr = {};
}

/**
 * Callback after the data is loaded.
 */
lunrSearch.prototype.initLunrSearch = function () {

  this.documents.map((document, index) => {
    this.indexMap[document[this.indexPrimaryKey]] = index;
  });

  const _this = this;
  this.lunr = new lunr(function () {
    this.ref(_this.indexPrimaryKey);
    Object.keys(_this.indexedFields).map(field => {
      this.field(field);
    });
    _this.documents.forEach(function (document) {
      this.add(document);
    }, this);
  });
  this.isLoading = false;
  this.isReady = true;
  this.search();
};


lunrSearch.prototype.updateStatus = function(){
  this.hasResults = (this.totalResults > 0);
  this.hasMoreResults =  (this.totalResults > 0 && this.totalResults > this.totalItems);
};

lunrSearch.prototype.getTargetPage = function(){
  if (this.targetPage){
    const targetUrl = new URL(this.targetPage);
    if(this.searchQuery){
      const targetQueryString = new URLSearchParams({search:this.searchQuery}).toString();
      targetUrl.search = targetQueryString;
    }
    return targetUrl.toString();
  }
  return false;
};

lunrSearch.prototype.gotoPage = function(){
  const targetUrl = this.getTargetPage();
  if (targetUrl){
    location.href = targetUrl;
  }
};

lunrSearch.prototype.search = function () {
  let searchQuery = '';
  if (this.searchQuery.length >= this.minChars) {
    if (false !== this.isReady) {
      //let searchQuery = this.searchQuery;
      searchQuery = `${this.searchQuery}`;
      let resultsMap = this.mapSearchResults(this.lunr.search(searchQuery));
      this.searchBoostField(resultsMap);
      this.totalResults = resultsMap.size;
      if (this.totalResults > 0) {
        let resultsArray = Array.from(resultsMap.keys());
        if (this.totalResults > this.totalItems) {
          resultsArray = resultsArray.slice(0, this.totalItems);
        }

        this.searchResults = resultsArray.map((refId) => {
          return { listItem: this.documents[this.indexMap[refId]][this.listItem] };
        });
      }
      this.updateStatus();
    }
    else {
      this.loadData();
    }

  }
};

lunrSearch.prototype.searchBoostField = function (searchResultMap) {
  if (this.boostField) {
    const words = this.searchQuery.split(' ');
    let boostQuery = '';
    const boostField = this.boostField;
    words.forEach(function (word) {
      boostQuery += `+${boostField}:${word} `;
    });
    const boostResults = this.lunr.search(boostQuery);
    boostResults.forEach(result => {
      // boost search result score if
      if (searchResultMap.has(result.ref)) {
        let score = searchResultMap.get(result.ref);
        score = score + result.score;
        searchResultMap.set(result.ref, score);
      }
    });
  }
};

lunrSearch.prototype.mapSearchResults = function (searchResults) {
  const searchResultMap = new Map();
  searchResults.forEach(result => {
    searchResultMap.set(result.ref, result.score);
  });
  return searchResultMap;
};

/**
 * Load the data from the endpoint.
 */
lunrSearch.prototype.loadData = function () {
  this.isLoading = true;
  const self = this;
  const xhr = new XMLHttpRequest();
  xhr.open('GET', this.documentSourceEndoint);
  xhr.responseType = 'json';
  xhr.onload = function () {
    if (this.readyState === 4) {
      self.documents = this.response;
      self.initLunrSearch();
    }
    else {
      self.isLoading = false;
      self.hasError = true;
    }
  };
  xhr.send();
};

document.addEventListener('alpine:init', () => {
  Alpine.data('lunrAutocomplete', () => ({
      lunrSearch: new lunrSearch(drupalSettings.lunrItemsjsSettings)
    })
  );
});




