<?php

namespace Drupal\views_lunr_itemsjs\Twig;

use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;


/**
 * Twig extension.
 */
class SearchApiItemsjsLunrTwigExtension extends AbstractExtension {

  /**
   * The plugin.manager.block service.
   *
   * @var \Drupal\Component\Plugin\PluginManagerInterface
   */
  protected $pluginManagerBlock;

  /**
   * The language manager.
   *
   * @var \Drupal\Core\Language\LanguageManagerInterface
   */
  protected $languageManager;

  /**
   * Constructs a new SearchApiItemsjsLunrTwigExtension object.
   *
   * @param \Drupal\Component\Plugin\PluginManagerInterface $plugin_manager_block
   *   The plugin.manager.block service.
   * @param \Drupal\Core\Language\LanguageManagerInterface $language_manager
   *   The language manager.
   */
  public function __construct(PluginManagerInterface $plugin_manager_block, LanguageManagerInterface $language_manager) {
    $this->pluginManagerBlock = $plugin_manager_block;
    $this->languageManager = $language_manager;
  }

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction('search_block', [$this, 'buildSearchBlock']),
      new TwigFunction('lunr_itemsjs_block', [$this, 'buildSearchBlock']),
    ];
  }


  public function buildSearchBlock(string $configMachineName): array {
    $configuration = ['search_configuration' => $configMachineName];
    $build = [];
    try {
      $block_plugin = $this->pluginManagerBlock->createInstance('lunr_itemsjs_block', $configuration);
      if ($block_plugin) {
        $build = $block_plugin->build();
      }
    } catch (PluginException $exception){
      // Perhaps log instead of rendering a blunt message
      $build['#markup'] = $exception->getMessage();
    }
    return $build;

  }

}
