<?php

namespace Drupal\views_lunr_itemsjs\Plugin\views\style;

use Drupal\Core\Cache\Cache;
use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\node\Entity\Node;
use Drupal\views\Plugin\views\style\StylePluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Serializer\SerializerInterface;

/**
 * The style plugin for serialized output formats.
 *
 * This class is largely based on the core REST module.
 *
 * @ingroup views_style_plugins
 *
 * @ViewsStyle(
 *   id = "lunr_search_index_json",
 *   title = @Translation("LunrItemsjs search index JSON"),
 *   help = @Translation("Serializes views row data to JSON."),
 *   display_types = {"lunr_search_index"}
 * )
 */
class LunrSearchIndexJson extends StylePluginBase implements CacheableDependencyInterface {

  /**
   * {@inheritdoc}
   */
  protected $usesRowPlugin = TRUE;

  /**
   * {@inheritdoc}
   */
  protected $usesGrouping = FALSE;

  /**
   * The serializer which serializes the views result.
   *
   * @var \Symfony\Component\Serializer\Serializer
   */
  protected $serializer;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('serializer')
    );
  }

  /**
   * Constructs a Plugin object.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, SerializerInterface $serializer) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->serializer = $serializer;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {

    $rows = [];
    $results = [];
    $currentLanguage = \Drupal::languageManager()->getCurrentLanguage()->getId();
    foreach ($this->view->result as $result){
      /** @var Node $node */
      $node = $result->_entity;
      $nid = $node->id();
      if (!$results[$nid]){
        $results[$nid] = $result;
      }
      // override if translation is available.
//      if ($node->hasTranslation($currentLanguage)){
//
//        $translation = $node->getTranslation($currentLanguage);
//        $results[$nid] = $result;
//        $results[$nid]->_entity = $node->getTranslation($currentLanguage);
//
//      }
    }
    foreach ($results as $row_index => $row) {
      $this->view->row_index = $row_index;
      $output = $this->view->rowPlugin->render($row);
      $uuid = $output['_itemsjs_id'];
      // UUID is assumed to be unique
      $rows[$uuid] = $output;
    }
    unset($this->view->row_index);
    return $this->serializer->serialize(array_values($rows), 'json');
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts() {
    return ['request_format'];
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheMaxAge() {
    return Cache::PERMANENT;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies() {
    $dependencies = parent::calculateDependencies();
    $dependencies['module'][] = 'serialization';
    return $dependencies;
  }

}
