<?php

namespace Drupal\views_lunr_itemsjs\Controller;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Cache\CacheableJsonResponse;
use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Controller\ControllerBase;
use Drupal\views_lunr_itemsjs\Entity\lunrItemsjs;
use Drupal\views_lunr_itemsjs\lunrItemsConfigInterface;

class LunrItemsjsIndexController extends ControllerBase {


  public function json($lunr_itemsjs) :CacheableJsonResponse{
    /** @var \Drupal\views_lunr_itemsjs\Entity\lunrItemsjs $lunrItemsjsConfig */
    $lunrItemsjsConfig = $this->entityTypeManager()->getStorage('lunr_itemsjs')->load($lunr_itemsjs);
    $view = $lunrItemsjsConfig->getViewExecutable();
    $build = $view->getDisplay()->execute();
    $cache = CacheableMetadata::createFromRenderArray($build);
    $response = new CacheableJsonResponse($build['#markup']);
    $response->addCacheableDependency($cache);
    if ($lunrItemsjsConfig->getDisplayType() === 'overview'){
      $settings = $lunrItemsjsConfig->getSettings();
      $cacheMaxAge = $settings['cache_max_age'] ?? 900;
      ($settings['cache_public'] ?? true)? $response->setPublic():$response->setPrivate();
      if ($cacheMaxAge > 0){
        $response->setMaxAge($cacheMaxAge);
      }
    } else {
      $response->setPrivate();
    }
    return $response;
  }


  /**
   * Checks if the requested
   * @param lunrItemsjs $lunrItemsjs
   *
   * @return mixed
   */
  public function access($lunr_itemsjs) {
    $config = $this->entityTypeManager()->getStorage('lunr_itemsjs')->load($lunr_itemsjs);
    return AccessResult::allowedIf($config instanceof lunrItemsConfigInterface);
  }

}
