## Documentation



### Introduction

This module provides a full client side rendered alternative for a more traditional views + facets approach while still using Drupal views as the datasource for it. Allowing you to utilize views for the heavy data lifting part, yet doing all the filtering and rendering fully client side using AlpineJS as the reactive layer.

The javascript portion of the Lunr and ItemsJS part is build framework agnostically so you can implement your own frontend system if you want to. 


### Overriding methods in the main libraries

```js
const initView = lunrItemsjs.prototype.initView;

lunrItemsjs.prototype.initView = function () {
  console.log('Init view');
  initView.apply(this);
};
```

### Pre and Postfiltering

There are two hooks available where you can manipulate the search results before they are mapped back to the `this.searchResults` variable.
Both hooks are only executed upon a user interaction, and **not** executed for the initial fill of the overview.
Hook `preFilter` 


This hook is executed after the fulltext search (lunrSearch) has been executed and contains an array filled  `_itemsjs_id` of the documents that matched the fulltext search.


The hook accepts and array with ids, and should return an empty array or a new array with ids, these id's are then used as limiter for the results in the itemsJS search.

For example a simple dutch zipcode search that removes all the documents that are not within a given radius

```js
lunrItemsjs.prototype.preFilter = function(ids){
   if (this.searchQuery.zipcode){
    const zipcode = this.searchQuery.zipcode.trim().substring(0, 4);
    // Invalid zipcode, nothing matches.
    if (!lunrItemsjs.lut_nl_zipcode.hasOwnProperty(zipcode)) {
      ids = [];
    } else {
      const zipcodeSource = {
        lat: lunrItemsjs.lut_nl_zipcode[zipcode][0],
        long: lunrItemsjs.lut_nl_zipcode[zipcode][1],
        radius: parseInt(this.searchQuery?.zipcode_radius ?? 5)
      };
      // zipCodeFilter is a function that maps latitude/longitude to a 'flatEarth' distance.
      ids = this.documents.filter(document => {
        if ((document.latitude && document.longitude) && zipCodeFilter(zipcodeSource, document) && ids.includes(document._itemsjs_id)) {
          return document._itemsjs_id;
        }
      }).map(document => document._itemsjs_id);
    }
  }
  return ids;
}
```

Hook `postFilter` 

This hook is executed after the itemsJS has been executed and contains an filled with the `listItems` of the documents that are about the stored on `this.searchResults`

the array is keyed on index, 
```js
searchResults[0] = {listItem : "html string"};
searchResults[1] = {listItem : "html string"};
...
```

Th


### Configuration
Before you setup an autocomplete search or itemsjs overview you need to create a Lunr Index.
This module assumes you know what you want to search and find, so we are only going to tell you about the special Lunr fields in Search API

#TODO Describe these
- Lunr Label
- Lunr Store only
- Lunr Url
- Lunr Summary Source
- Lunr Boost



### Customize the output

- [Itemjs](https://github.com/itemsapi/itemsjs) ItemJS
- [Oliver Nightingale](https://github.com/olivernn/lunr.js) Lunr, the browser based Solr search, but not as bright.
- [ARA](https://www.ara.nl) for creating this module.



