## Documentation



### Introduction

This module provides a full client side rendered alternative for a more traditional views + facets approach while still using the Search API ecosystem.
In order to achieve this, we needed to a hard fork of [Search API Lunr](https://www.drupal.org/project/search_api_lunr) with some additions in order to get the hard fork [ItemsJS](https://github.com/itemsapi/itemsjs).

The main goal of this combination of forks and custom code was that their was a almost zero dependency on external scripts. So this module isn't using any jQuery under the hood and relies on [Drupal.once](https://www.npmjs.com/package/@drupal/once) package instead.

### Configuration
Before you setup an autocomplete search or itemsjs overview you need to create a Lunr Index.
This module assumes you know what you want to search and find, so we are only going to tell you about the special Lunr fields in Search API

#TODO Describe these
- Lunr Label
- Lunr Store only
- Lunr Url
- Lunr Summary Source
- Lunr Boost

#### Create a search configuration

admin/config/search/itemsjs-lunr-configuration



### Render output

There are two ways to render the output of this module.

If you need to the block on all pages, for example a auto complete search in the header the easiest way to accomplish this is by placing the block and setting the context conditions if applicable.

At the other hand, you might need a overview on a specific place, let's say in a Paragraph you can render a block directly from within your Twig template by using the `search_block` function.

This function accepts the machine name of a search configuration, builds and renders the block directly in your template.
```
<h1>Look at my view</>
{{ search_block('collection') }}
```

### Customize the output

All javascript templating is done using data attributes.

If you look at templates/items-js.html.twig you will see that there are various zone's defined using the `data-itemsjs="header"` directive.
The `innerhtml` of these elements are replaced using the render* methods defined in `js/src/drupal/drupal.itemsjs.js` and called in the `Drupal.behaviors.searchApiItemsjsLunr.renderView` method.
This method is called after every search action a user performs on the site.

The items are rendered from using the Lodash.render methode with a precompiled template.
Upon init all script items that are tagged with a `data-itemsjs-template` are precompiled upon init and stored under `Drupal.behaviors.searchApiItemsjsLunr.preCompiledTemplates`
These functions are callable using the name defined in `data-itemsjs-template`.

```javascript
<script type="drupal/template" data-itemsjs-template="list_item">
    {{content}}
</script>
```
becomes
`Drupal.behaviors.searchApiItemsjsLunr.preCompiledTemplates.list_item`

And is callable using

```javascript
const output = this.preCompiledTemplates.list_item({content:'<p>Hello Drupal</p>'})
```

### Caveats and Todo's

This version of the system is language aware, and creates a local storage cache  of the Index per language.

In order to get a smaller bundle size we included a customized version of lodash stored, if needed you can extend the included lodash components be editing the `build-lodash` directive in `/js/package-lock.json`

_Todo_
- Configurable localstorage cache
- Configurable multi language behaviour.
- Re-implement the placing logic of the filters, so you can place a filter or facet on any place in the template.
- Describe how to extend the logic, for example add a 'banner' every 10 results.




### Credits

- [Sam Becker](https://www.drupal.org/u/sam152) for the original implementation of SearchAPI Lunr
- [Itemjs](https://github.com/itemsapi/itemsjs) ItemJS
- [Oliver Nightingale](https://github.com/olivernn/lunr.js) Lunr, the browser based Solr search, but not as bright.
- [ARA](https://www.ara.nl) for creating this module.



