function lunrSearch (settings) {
  this.documentSourceEndoint = settings.source;

  this.language = settings.language; // Fetch from DrupalSettings?

  // Lunr Searchable fields
  this.indexedFields = settings.indexed_fields;
  // Available sort options
  this.sorts = settings.sorts;
  this.indexPrimaryKey = settings.index_primary ?? '_itemsjs_id';

  // Item used for rendering results can be string or template
  this.listItem = settings.list_item;
  this.minChars = parseInt(settings.settings.min_chars)?? 3;
  this.searchMode = settings.settings.search_mode ?? 'partial';
  this.targetPage = settings.target_page
  /**
   * Maps the primary key to the original index
   * @type {*[]}
   */
  this.indexMap = [];
  /**
   * Loading state
   * @type {boolean}
   */
  this.isLoading = false;
  /**
   * Search is ready to search
   * @type {boolean}
   */
  this.isReady = false;
  /**
   * Search yielded results
   * @type {boolean}
   */
  this.hasResults = false;
  /**
   * Search has more then this.totalItems results
   * @type {boolean}
   */
  this.hasMoreResults = false;

  /**
   * Has load error?
   * @type {boolean}
   */
  this.hasError = false;

  /**
   * Max items to show
   * @type {number|*}
   */
  this.totalItems = settings.per_page;

  this.totalResults = 0;

  /**
   *  Indexable documents, loaded from the the documentSourceEndoint
   * @type {*[]}
   */
  this.documents = [];
  /**
   * Results for this page after a search has been performed.
   * @type { {} }
   */
  this.searchResults = {};

  /**
   * The query to search for.
   * @type {string}
   */
  this.searchQuery = '';

  /**
   * Bind for fully indexed Lunr
   * @type {lunr|{}}
   */
  this.lunr = {};
}

/**
 * Callback after the data is loaded.
 */
lunrSearch.prototype.initLunrSearch = function () {

  this.documents.map((document, index) => {
    this.indexMap[document[this.indexPrimaryKey]] = index;
  });

  const _this = this;
  this.lunr = new lunr(function () {
    this.ref(_this.indexPrimaryKey);
    Object.keys(_this.indexedFields).map(field => { this.field(field); });
    _this.documents.forEach(function (document) {
      this.add(document)
    }, this)
  });
  this.isLoading = false;
  this.isReady = true;
  this.search();
};


lunrSearch.prototype.updateStatus = function(){
  this.hasResults = (this.totalResults > 0);
  this.hasMoreResults =  (this.totalResults > 0 && this.totalResults > this.totalItems);
}

lunrSearch.prototype.getTargetPage = function(){
  if (this.targetPage){
    const targetUrl = new URL(this.targetPage);
    if(this.searchQuery){
      const targetQueryString = new URLSearchParams({search:this.searchQuery}).toString();
      targetUrl.search = targetQueryString;
    }
    return targetUrl.toString();
  }
  return false;
}

lunrSearch.prototype.gotoPage = function(){
  const targetUrl = this.getTargetPage();
  if (targetUrl){
    location.href = targetUrl
  }
}

lunrSearch.prototype.search = function () {
  if (this.searchQuery.length >= this.minChars) {
    if (false !== this.isReady) {
      let searchQuery = '';
      switch (this.searchMode) {
        case 'partial':
          searchQuery = `*${this.searchQuery}*`;
          break;
        case 'full':
          searchQuery = this.searchQuery;
          break;
        case'starts':
          searchQuery = `${this.searchQuery}*`;
          break;
        case 'ends':
          searchQuery = `*${this.searchQuery}`;
          break;
      }
      let results = this.lunr.search(searchQuery);
      this.totalResults = results.length;
      if (this.totalResults > 0) {
        if (this.totalResults > this.totalItems){
          results = results.slice(0, this.totalItems);
        }
        this.searchResults = results.map((result) => {
          return { listItem: this.documents[this.indexMap[result.ref]][this.listItem] };
        });
      }
      this.updateStatus()
    }
    else {
      this.loadData();
    }

  }
};

/**
 * Load the data from the endpoint.
 */
lunrSearch.prototype.loadData = function () {
  this.isLoading = true;
  const self = this;
  const xhr = new XMLHttpRequest();
  xhr.open('GET', this.documentSourceEndoint);
  xhr.responseType = 'json';
  xhr.onload = function () {
    if (this.readyState === 4) {
      self.documents = this.response;
      self.initLunrSearch();
    }
    else {
      self.isLoading = false;
      self.hasError = true;
    }
  };
  xhr.send();
};

document.addEventListener('alpine:init', () => {
  Alpine.data('lunrAutocomplete', () => ({
      lunrSearch: new lunrSearch(drupalSettings.lunrItemsjsSettings)
    })
  );
});




