import Window from 'public/libraries/jquery.inputmask/lib/global/window';

function lunrSearch (settings) {
  this.documentSourceEndoint = settings.source;

  this.language = settings.language; // Fetch from DrupalSettings?

  // Lunr Searchable fields
  this.indexedFields = settings.indexed_fields;
  // Available sort options
  this.sorts = settings.sorts;
  this.indexPrimaryKey = settings.index_primary ?? '_itemsjs_id';

  // Item used for rendering results can be string or template
  this.listItem = settings.list_item;
  this.minChars = parseInt(settings.settings.min_chars)?? 3;
  this.searchMode = settings.settings.search_mode ?? 'partial';
  this.targetPage = settings.target_page
  /**
   * Maps the primary key to the original index
   * @type {*[]}
   */
  this.indexMap = [];
  /**
   * Loading state
   * @type {boolean}
   */
  this.isLoading = false;
  this.isReady = false;
  /**
   * Has load error?
   * @type {boolean}
   */
  this.hasError = false;

  /**
   * Max items to show
   * @type {number|*}
   */
  this.totalItems = settings.per_page;

  /**
   *  Indexable documents, loaded from the the documentSourceEndoint
   * @type {*[]}
   */
  this.documents = [];
  /**
   * Results for this page after a search has been performed.
   * @type { {} }
   */
  this.searchResults = {};

  /**
   * The query to search for.
   * @type {string}
   */
  this.searchQuery = '';

  /**
   * Bind for fully indexed Lunr
   * @type {lunr|{}}
   */
  this.lunr = {};
}

/**
 * Callback after the data is loaded.
 */
lunrSearch.prototype.initLunrSearch = function () {

  this.documents.map((document, index) => {
    this.indexMap[document[this.indexPrimaryKey]] = index;
  });

  const _this = this;
  this.lunr = new lunr(function () {
    this.ref(_this.indexPrimaryKey);
    Object.keys(_this.indexedFields).map(field => { this.field(field); });
    _this.documents.forEach(function (document) {
      this.add(document)
    }, this)
  });
  this.isLoading = false;
  this.isReady = true;
  this.search();
};

lunrSearch.prototype.gotoPage = function(){
  if (this.targetPage){
    const targetUrl = new URL(this.targetPage);
    const targetQueryString = new URLSearchParams({search:this.searchQuery}).toString();
    targetUrl.search = targetQueryString;
    location.href = targetUrl.toString();
  }
}

lunrSearch.prototype.search = function () {
  if (this.searchQuery.length >= this.minChars) {
    if (false !== this.isReady) {
      let searchQuery = '';
      switch (this.searchMode) {
        case 'partial':
          searchQuery = `*${this.searchQuery}*`;
          break;
        case 'full':
          searchQuery = this.searchQuery;
          break;
        case'starts':
          searchQuery = `${this.searchQuery}*`;
          break;
        case 'ends':
          searchQuery = `*${this.searchQuery}`;
          break;
      }
      const results = this.lunr.search(searchQuery);
      if (results.length > 0) {
        let searchResults = results.slice(0, this.itemsPerPage);
        this.searchResults = searchResults.map((result) => {
          return { listItem: this.documents[this.indexMap[result.ref]][this.listItem] };
        });
      }
    }
    else {
      this.loadData();
    }

  }
};

/**
 * Load the data from the endpoint.
 */
lunrSearch.prototype.loadData = function () {
  this.isLoading = true;
  const self = this;
  const xhr = new XMLHttpRequest();
  xhr.open('GET', this.documentSourceEndoint);
  xhr.responseType = 'json';
  xhr.onload = function () {
    if (this.readyState === 4) {
      self.documents = this.response;
      self.initLunrSearch();
    }
    else {
      self.isLoading = false;
      self.hasError = true;
    }
  };
  xhr.send();
};

document.addEventListener('alpine:init', () => {
  Alpine.data('lunrAutocomplete', () => ({
      lunrSearch: new lunrSearch(drupalSettings.lunrItemsjsSettings)
    })
  );
});




