<?php

namespace Drupal\views_lunr_itemsjs;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of search configurations.
 */
class LunrItemsjsConfigListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['id'] = $this->t('Machine name');
    $header['view'] = $this->t('Views source');
    $header['display'] = $this->t('Display type');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $displayTypes = [
      'overview' => $this->t('Faceted search'),
      'search' => $this->t('Autocomplete search'),
    ];
    /** @var \Drupal\views_lunr_itemsjs\lunrItemsConfigInterface $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['view'] = $entity->getViewID();
    $row['display'] = $displayTypes[$entity->getDisplayType()];
    return $row + parent::buildRow($entity);
  }
}
