<?php

namespace Drupal\vacancy_redirect\Form;

use Drupal;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Vacancy Redirect settings for this site.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'vacancy_redirect_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['vacancy_redirect.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $availableFields = $this->getApplicableVacancyFields();
    $form['field'] = [
      '#type' => 'select',
      '#title' => $this->t('Source field'),
      '#options' => $availableFields,
      '#sort_options' => TRUE,
      '#default_value' => $this->config('vacancy_redirect.settings')
        ->get('field'),
      '#description' => $this->t('Select the field that has the unique identifier for a vacancy.'),
      '#required' => TRUE,
    ];
    return parent::buildForm($form, $form_state);
  }


  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('vacancy_redirect.settings')
      ->set('field', $form_state->getValue('field'))
      ->save();
    parent::submitForm($form, $form_state);
  }

  private function getApplicableVacancyFields() : array {
    $fields = \Drupal::getContainer()->get('entity_field.manager')
      ->getFieldDefinitions('node', 'vacancies');
    $availableFields = [];
    foreach ($fields as $field => $fieldConfig) {
      // for now only do custom fields of string or int, no fancy markup shizzle.
      if (substr_count($field, 'field_') && in_array($fieldConfig->getType(), [
          'string',
          'int',
        ])) {
        $availableFields[$field] = $fieldConfig->getLabel();
      }
    }
    return $availableFields;
  }

}
