<?php

namespace Drupal\vacancy_redirect\Controller;

use Drupal\Component\Utility\Xss;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Routing\Exception\RouteNotFoundException;

/**
 * Returns responses for Vacancy Redirect routes.
 */
class VacancyRedirectController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function redirectById($id) {

    $id = (string) Xss::filter($id);
    if ($id) {
      $nid = $this->findVacancyByUniqueId($id);
      if ($nid) {
        return $this->redirect('entity.node.canonical', ['node' => $nid]);
      }
    }
    throw new NotFoundHttpException();
  }

  protected function findVacancyByUniqueId(string $id): bool|int {
    $uniqueField = $this->config('vacancy_redirect.settings')->get('field');
    $nodeStorage = $this->entityTypeManager()->getStorage('node');
    $node = $nodeStorage->loadByProperties([
      'type' => 'vacancies',
      $uniqueField => $id,
    ]);
    if (!$node) {
      return FALSE;
    }
    $node = reset($node);
    return $node->id();
  }

}
