<?php

namespace Drupal\twig_extras\Twig\Extension;

use Drupal\Core\Site\Settings;
use Drupal\Core\Url;
use Drupal\twig_extras\Twig\Extension\TokenParser\SwitchTokenParser;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;


class TwigExtrasExtension extends AbstractExtension {

  public function getTokenParsers(): array {
    $parsers = [];
    $parsers[] = new SwitchTokenParser();
    return $parsers;
  }

  public function getFunctions(): array {
    $functions = [];
    $functions[] = new TwigFunction('drupal_is_frontpage', function () {
      return \Drupal::service('path.matcher')->isFrontPage();
    });
    $functions[] = new TwigFunction('from_uri', function ($uri) {
      return Url::fromUri($uri)->toString();
    });
    $functions[] = new TwigFunction('drupal_setting', function ($name, $default = NULL) {
      return Settings::get($name, $default);
    });
    return $functions;
  }

    public function getTests(): array {
    $tests = [];
    $tests[] = new TwigTest('renderable', function ($input) {
      if (!empty($input)) {
        /**
         * If there are more then 2 items in the render array, check if it
         * has as '#theme' key. If so, it's renderable!
         */
        if (count($input) > 2) {
          return (isset($input['#theme']));
        }
        elseif (is_array($input)) {
          /**
           * If the field has no value, drupal still has #cache and #weight in the render array
           * So this is a non renderable item
           */
          return !(isset($input['#cache'], $input['#weight']));
        }
      }
      return false;
    });
    return $tests;
  }
}
