#Twig Extras



## Functions

### drupal_is_frontpage

```twig
{% if drupal_is_frontpage() %}
 <h1>Hi i'am only visible on the frontpage of your project</h1>
{% endif %}
```

### from_uri()
Transforms a internal URI to a URL String. Great in combination with field_raw on a Link field.

```twig
{{ set url = from_uri('entity:node/795') }}
```

```twig
{% set formTarget = from_uri(drupal_field('field_site_search_page', 'config_pages', 'site_settings')|field_raw('uri')) %}
```

### drupal_setting
Get a value from `$settings` system from `settings.php` in your twig template. This way you can add extra variables to that system without the need of using the configuration system.

Warning, be carefull not to override the core values, the safest way of using this is by prefixing your custom setting names!

Without default fallback value

```php
...
$settings['tagmanager_code'] = 'GTM-C0D3N4M3';
....

```twig
{% set tagmanager_code = drupal_setting('tagmanager_code') %}
```

With default fallback value as a very simple feature flag system.

```twig
{% if drupal_setting('feature_flag',false) %}
<pre>This feature is enabled!</pre>
{% endif %}
```
## Tags

### Switch / Case

A more readable version for the nested `if elseif elseif` blocks. Especially when you combine it with includes.

```twig
{% switch myVar %}
    {% case 'value1' %}
       {% include 'value1-template.html.twig' %}
    {% case 'value2' %}
        {# ...code here to run for value2 #}
    {% default %}
        {# ...code here to run for default when no case matched #}
{% endswitch %}
```

## Tests

Tests are clean way to check if a variable `is` of a certain context. See [Twig documentation](https://twig.symfony.com/doc/2.x/tests/index.html)

### renderable

In templates you sometimes need to check if a value is empty or renderable. Drupal render arrays however are never empty, they always contain two keys `#cache` and `#weight`. This is where the renderable test comes into place.

```twig
{% if content.field_something is renderable %}
 <h2>This is the content of field_something</h2>
 <pre>
   {{ content.field_something}}
 </pre>
{% endif %}
```

The condination can also be negated, with a not

```twig
{% if content.field_something is not renderable %}
 <h2>field_something is empty</h2>
{% endif %}
```


