<?php


namespace Drupal\schema_metatag_html;



use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;

class SchemaMetatagHtmlServiceProvider implements ServiceModifierInterface
{
  public function alter(ContainerBuilder $container) {
    $definitions = [
      'metatag.manager' => 'Drupal\schema_metatag_html\MetatagHTMLManager',
      'schema_metatag.schema_metatag_manager' => 'Drupal\schema_metatag_html\SchemaMetatagHTMLManager'
    ];

    foreach ($definitions as $definition => $replace) {
      $definition = $container->getDefinition($definition);
      if ($definition){
        $definition->setClass($replace);
      }
    }
  }
}
