<?php

namespace Drupal\schema_metatag_html;

use Drupal\Component\Render\PlainTextOutput;
use Drupal\Component\Utility\Html;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\metatag\MetatagManager;
use Drupal\views\ViewEntityInterface;

class MetatagHTMLManager extends MetatagManager
{

  /**
   * Yes this entire chunk of code needs to be duplicated to adjust
   * one minor part of it. If only the original makers had divided this
   * hunkadunk of code in several methods.
   *
   * @param array $tags
   * @param null $entity
   * @return array
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function generateRawElements(array $tags, $entity = NULL)
  {
    // Ignore the update.php path.
    $request = \Drupal::request();
    if ($request->getBaseUrl() == '/update.php') {
      return [];
    }

    // Prepare any tokens that might exist.
    $token_replacements = [];
    if ($entity) {
      // @todo This needs a better way of discovering the context.
      if ($entity instanceof ViewEntityInterface) {
        // Views tokens require the ViewExecutable, not the config entity.
        // @todo Can we move this into metatag_views somehow?
        $token_replacements = ['view' => $entity->getExecutable()];
      } elseif ($entity instanceof ContentEntityInterface) {
        $token_replacements = [$entity->getEntityTypeId() => $entity];
      }
    }

    // Ge the current language code.
    $langcode = \Drupal::languageManager()
      ->getCurrentLanguage(LanguageInterface::TYPE_CONTENT)
      ->getId();

    $rawTags = [];

    $metatag_tags = $this->tagPluginManager->getDefinitions();

    // Order the elements by weight first, as some systems like Facebook care.
    uksort($tags, function ($tag_name_a, $tag_name_b) use ($metatag_tags) {
      $weight_a = isset($metatag_tags[$tag_name_a]['weight']) ? $metatag_tags[$tag_name_a]['weight'] : 0;
      $weight_b = isset($metatag_tags[$tag_name_b]['weight']) ? $metatag_tags[$tag_name_b]['weight'] : 0;

      return ($weight_a < $weight_b) ? -1 : 1;
    });

    // Each element of the $values array is a tag with the tag plugin name as
    // the key.
    foreach ($tags as $tag_name => $value) {
      // Check to ensure there is a matching plugin.
      if (isset($metatag_tags[$tag_name])) {


        /**
         * This was the chunk of code that I needed to replace.
         * Refactored into a seperate method.
         */
        $tag = $this->getTagOutput($tag_name, $value, $token_replacements, $langcode);
        $output = $tag->output();

          if (!empty($output)) {
            $output = $tag->multiple() ? $output : [$output];

            // Backwards compatibility for modules which don't support this logic.
            if (isset($output['#tag'])) {
              $output = [$output];
            }

            foreach ($output as $index => $element) {
              // Add index to tag name as suffix to avoid having same key.
              $index_tag_name = $tag->multiple() ? $tag_name . '_' . $index : $tag_name;
              $rawTags[$index_tag_name] = $element;
            }
          }
        }
    }

    return $rawTags;
  }

  /**
   * @param string $tag_name
   * @param $value
   * @param array $token_replacements
   * @param string $langcode
   * @return object
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function getTagOutput(string $tag_name, $value, array $token_replacements, string $langcode)
  {
    $tag = $this->tagPluginManager->createInstance($tag_name);

    // Set the value as sometimes the data needs massaging, such as when
    // field defaults are used for the Robots field, which come as an array
    // that needs to be filtered and converted to a string.
    // @see Robots::setValue()
    $tag->setValue($value);
    // Obtain the processed value.
    $parsed = htmlspecialchars_decode((string)$this->tokenService->replace($tag->value(), $token_replacements, ['langcode' => $langcode]));
    $definition = $tag->getPluginDefinition();
    // If it's Schema_metatag the property type should be set
    // And we need the 'text' properties to be HTML based.
    if (isset($definition['property_type']) && $definition['property_type'] === 'text'){
      $processed_value = Html::decodeEntities(check_markup(nl2br($parsed), 'metatags', $langcode));
    } else {
      $processed_value = PlainTextOutput::renderFromHtml($parsed);
    }
    // Now store the value with processed tokens back into the plugin.
    $tag->setValue($processed_value);
    return $tag;
  }

}
