<?php


namespace Drupal\schema_metatag_html;


use Drupal\schema_metatag\SchemaMetatagManager;

class SchemaMetatagHTMLManager extends SchemaMetatagManager {

  /**
   * {@inheritdoc}
   */
  public static function encodeJsonld(array $items) {
    // If some group has been found, render the JSON LD,
    // otherwise return nothing.
    if (!empty($items)) {
      return json_encode($items, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }
    else {
      return '';
    }
  }
}
