<?php

namespace Drupal\matone_vacancy\Plugin;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\matone_vacancy\BackendInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class BackendBase
 *
 * Provides a base class for Backend plugins.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
abstract class BackendBase extends PluginBase implements BackendInterface, ContainerFactoryPluginInterface {

  /**
   * @inheritdoc
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * @inheritdoc
   */
  public function getConfiguration() {
    return $this->configuration;
  }

  /**
   * @inheritdoc
   */
  public function setConfiguration(array $configuration) {
    $this->configuration = $configuration;
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function defaultConfiguration() {
    return [];
  }
}
