<?php

namespace Drupal\matone_vacancy\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\matone_vacancy\Plugin\BackendPluginManager;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class SettingsForm
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class SettingsForm extends ConfigFormBase {

  /**
   * @var BackendPluginManager
   */
  private $backendPluginManager;

  /**
   * Constructor.
   *
   * @param ConfigFactoryInterface $config_factory
   * @param BackendPluginManager   $backend_plugin_manager
   */
  public function __construct(ConfigFactoryInterface $config_factory, BackendPluginManager $backend_plugin_manager) {
    parent::__construct($config_factory);
    $this->backendPluginManager = $backend_plugin_manager;
  }

  /**
   * @inheritdoc
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('plugin.manager.backend')
    );
  }

  /**
   * @inheritdoc
   */
  protected function getEditableConfigNames() {
    return ['matone_vacancy.settings'];
  }

  /**
   * @inheritdoc
   */
  public function getFormId() {
    return 'matone_vacancy_settings';
  }

  /**
   * @inheritdoc
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('matone_vacancy.settings');

    $backendTypes = [];
    foreach ($this->backendPluginManager->getDefinitions() as $id => $definition) {
      $backendTypes[$id] = $definition['title'] ?? $id;
    }

    $form['backend_type'] = [
      '#type' => 'select',
      '#title' => $this->t('Backend type'),
      '#options' => $backendTypes,
      '#default_value' => $config->get('backend_type')
    ];

    // TODO: Build settings form based on selected backend (So that we can create a configuration form for the backend)

    return parent::buildForm($form, $form_state);
  }

  /**
   * @inheritdoc
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->config('matone_vacancy.settings');
    $config
      ->set('backend_type', $form_state->getValue('backend_type'))
      ->save();

    parent::submitForm($form, $form_state);
  }
}
