<?php

namespace Drupal\matone_vacancy\Commands;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\matone_vacancy\BackendInterface;
use Drupal\matone_vacancy\Importer\VacancyImporter;
use Drupal\matone_vacancy\Plugin\BackendPluginManager;
use Drush\Commands\DrushCommands;
use Drush\Utils\StringUtils;

/**
 * Class VacancyCommands
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class VacancyCommands extends DrushCommands {

  /**
   * @var ConfigFactoryInterface
   */
  private $configFactory;

  /**
   * @var BackendPluginManager
   */
  private $backendPluginManager;

  /**
   * @var VacancyImporter
   */
  private $vacancyImporter;

  /**
   * Constructor.
   *
   * @param ConfigFactoryInterface $config_factory
   * @param BackendPluginManager                       $backend_plugin_manager
   * @param VacancyImporter                            $vacancy_importer
   */
  public function __construct(ConfigFactoryInterface $config_factory, BackendPluginManager $backend_plugin_manager, VacancyImporter $vacancy_importer) {
    $this->backendPluginManager = $backend_plugin_manager;
    $this->vacancyImporter = $vacancy_importer;
    $this->configFactory = $config_factory;
  }

  /**
   * Import vacancies.
   *
   * @command matone:import:vacancies
   * @aliases miv,matone-import-vacancies
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function importVacancies() {
    $config = $this->configFactory->get('matone_vacancy.settings');

    /** @var BackendInterface $backend */
    $backend = $this->backendPluginManager->createInstance($config->get('backend_type'));
    $vacancies = $backend->getVacancies();
    $result = $this->vacancyImporter->import($vacancies);

    $output = [
      'updated' => $result->getUpdates(),
      'created' => $result->getCreated(),
      'deleted' => $result->getDeleted()
    ];
    foreach ($output as $title => $data) {
      foreach ($data as $node) {
        $this->writeln(
          StringUtils::interpolate(
            '<info>@operation: @title (id: @nid)</info>',
            ['@operation' => $title, '@title' => $node->getTitle(), '@nid' => $node->id()]
          )
        );
      }
    }
  }
}
