<?php

namespace Drupal\matone_vacancy;

use Drupal\Core\Utility\Error;
use Psr\Log\LogLevel;


class ErrorLogger {

  /**
   * Log warning, and move on.
   */
  public static function warningException(\Throwable $exception, string $message = Error::DEFAULT_ERROR_MESSAGE, array $additional_variables = [], string $level = LogLevel::WARNING) {
    $logger = \Drupal::logger('vacancy');
    Error::logException($logger, $exception, $message, $additional_variables, $level);
  }

  /**
   * Log and re-throw the error.
   * @throws \Throwable
   */
  public static function fatalException(\Throwable $exception, string $message = Error::DEFAULT_ERROR_MESSAGE, array $additional_variables = [], string $level = LogLevel::CRITICAL) {
    $logger = \Drupal::logger('vacancy');
    Error::logException($logger, $exception, $message, $additional_variables, $level);
    throw $exception;
  }

}
