<?php

namespace Drupal\matone_vacancy;

/**
 * Interface VacancyInterface
 *
 * Simple base definition for vacancies.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
interface VacancyInterface extends MappableObject {

  /**
   * Get vacancy id.
   *
   * @return int
   */
  public function getId();

  /**
   * Set the vacancy id.
   *
   * @param $id
   *
   * @return VacancyInterface
   */
  public function setId($id);

  /**
   * Get vacancy title.
   *
   * @return string
   */
  public function getTitle();

  /**
   * Set the vacancy title.
   *
   * @param $title
   *
   * @return VacancyInterface
   */
  public function setTitle($title);
}
