<?php

namespace Drupal\matone_vacancy\Importer\Operation;

use Drupal\Core\Entity\EntityStorageException;
use Drupal\matone_vacancy\ErrorLogger;
use Drupal\matone_vacancy\PipeInterface;
use Drupal\matone_vacancy\ResultInterface;
use Drupal\node\Entity\Node;

/**
 * Class TranslateOperation
 *
 */
class TranslateOperation implements PipeInterface
{

	function getIgnoreUpdateFields()
	{
		return [
		];
	}

	function getIgnoreCreateFields()
	{
		return [
		];
	}

	/**
	 * @inheritdoc
	 */
	public function handle($data, \Closure $next)
	{
		$translation_data = $data['data']['translations'];
		foreach ($translation_data as $key => $node) {
			$sourceNode = $this->findSourceNode($data, $node['field_vacancy_id']);
			if ($sourceNode && $sourceNode->hasTranslation($node['langcode'])) {
				foreach ($this->getIgnoreUpdateFields() as $field) {
					unset($translation_data[$key][$field]);
				}
			} else {
				foreach ($this->getIgnoreCreateFields() as $field) {
					unset($translation_data[$key][$field]);
				}
			}
		}

		/** @var ResultInterface $result */
		$result = $data['result'];

		$failed = $result->getFailed();
		$created = $result->getCreated();
		$updates = $result->getUpdates();

		$created_nodes = array_merge($updates, $created);
		foreach ($created_nodes as $index => $node) {
			$created_nodes[$node->get('field_vacancy_id')->value] = $node;
			unset($created_nodes[$index]);
		}

		foreach ($translation_data as $translation) {
			if (isset($created_nodes[$translation['field_vacancy_id']])) {
				$langcode = $translation['langcode'];

				/** @var Node $node */
				$node = $created_nodes[$translation['field_vacancy_id']];
				$translated_node = $node->hasTranslation($langcode)
					? $node->getTranslation($langcode)
					: $node->addTranslation($langcode);

				unset($translation['langcode'], $translation['type']);
				foreach ($translation as $field => $value) {
					$translated_node->set($field, $value);
				}

				try {
					$translated_node->save();
				} catch (EntityStorageException $exception) {
          ErrorLogger::warningException($exception,'Error in Translate operation (@message)');
					$failed[] = $translation;
				}

				$updates[] = $translated_node;
			}
		}

		$result
			->setFailed($failed)
			->setUpdates($updates);

		return $next($data);
	}

	/**
	 * @param $data
	 * @param $key
	 * @return bool|Node
	 */
	private function findSourceNode($data, $key)
	{
		/** @var Node $sourceNode */
		$sourceNode = false;
		if (isset($data['data']['update'][$key])) {
			$sourceNode = $data['data']['update'][$key]['node'];
		} elseif (isset($data['data']['create'][$key])) {
			$sourceNode = $data['data']['update'][$key]['node'];
		}
		return $sourceNode;
	}
}
