<?php

namespace Drupal\matone_vacancy;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;

/**
 * Interface BackendInterface
 *
 * The different types of back-end should implement this class for
 * basic usage.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
interface BackendInterface extends ConfigurableInterface, PluginInspectionInterface, PluginFormInterface {

  /**
   * Get vacancies from the given source.
   *
   * @return VacancyInterface[]
   */
  public function getVacancies();
}
