<?php

namespace Drupal\matone_vacancy\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a backend annotation object.
 *
 * Plugin Namespace: Plugin\Backend
 *
 * @see \Drupal\matone_vacancy\Plugin\BackendPluginManager
 * @see plugin_api
 *
 * @Annotation
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class Backend extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The readable name of the back-end type.
   *
   * @ingroup plugin_translatable
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $title;
}
