<?php

namespace Drupal\matone_vacancy;

/**
 * Interface ResultInterface
 *
 * This class should contain the results of an import and should know
 * how many entities are created, updated, deleted or failed.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
interface ResultInterface {

  /**
   * Get the amount of created entities.
   *
   * @return array
   */
  public function getCreated();

  /**
   * Set the amount of created entities.
   *
   * @param array $created
   *
   * @return ResultInterface
   */
  public function setCreated(array $created);

  /**
   * Get the amount of updated entities.
   *
   * @return array
   */
  public function getUpdates();

  /**
   * Set the amount of updated entities.
   *
   * @param array $updated
   *
   * @return ResultInterface
   */
  public function setUpdates(array $updated);

  /**
   * Get the amount of deleted entities.
   *
   * @return array
   */
  public function getDeleted();

  /**
   * Set the amount of deleted entities.
   *
   * @param array $deleted
   *
   * @return ResultInterface
   */
  public function setDeleted(array $deleted);

  /**
   * Get the amount of failed entities.
   *
   * @return array
   */
  public function getFailed();

  /**
   * Set the amount of failed entities.
   *
   * @param array $failed
   *
   * @return ResultInterface
   */
  public function setFailed(array $failed);
}
