<?php

namespace Drupal\matone_vacancy;

/**
 * Class ImportResult
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class ImportResult implements ResultInterface {

  /**
   * @var array
   */
  private $results;

  /**
   * Constructor.
   */
  public function __construct() {
    $this->results = [
      'created' => [],
      'updates' => [],
      'deleted' => [],
      'failed'  => []
    ];
  }

  /**
   * @inheritdoc
   */
  public function getCreated() {
    return $this->results['created'];
  }

  /**
   * @inheritdoc
   */
  public function setCreated(array $created) {
    $this->results['created'] = $created;
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function getUpdates() {
    return $this->results['updates'];
  }

  /**
   * @inheritdoc
   */
  public function setUpdates(array $updated) {
    $this->results['updates'] = $updated;
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function getDeleted() {
    return $this->results['deleted'];
  }

  /**
   * @inheritdoc
   */
  public function setDeleted(array $deleted) {
    $this->results['deleted'] = $deleted;
    return $this;
  }

  /**
   * @inheritdoc
   */
  public function getFailed() {
    return $this->results['failed'];
  }

  /**
   * @inheritdoc
   */
  public function setFailed(array $failed) {
    $this->results['failed'] = $failed;
    return $this;
  }
}
