<?php

namespace Drupal\matone_vacancy\Plugin\Mapping;

use Drupal\matone_vacancy\Plugin\MappingBase;

/**
 * @Mapping(
 *   id = "wysiwyg_mapping"
 * )
 */
class WysiwygMapping extends MappingBase {

  /**
   * @inheritdoc
   */
  public function map($data) {
    if (!$data) {
      return '';
    }

    return [
      'value' => check_markup(html_entity_decode($data), 'wysiwyg'),
      'format' => 'wysiwyg'
    ];
  }
}
