<?php

namespace Drupal\matone_vacancy\Plugin;

use Drupal\Component\Plugin\FallbackPluginManagerInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\matone_vacancy\Annotation\Backend;
use Drupal\matone_vacancy\BackendInterface;

/**
 * Class BackendPluginManager
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class BackendPluginManager extends DefaultPluginManager implements FallbackPluginManagerInterface {

  /**
   * Constructor.
   *
   * @param \Traversable           $namespaces
   * @param CacheBackendInterface  $cache_backend
   * @param ModuleHandlerInterface $module_handler
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/Backend', $namespaces, $module_handler, BackendInterface::class, Backend::class);

    $this->alterInfo('backend_info');
    $this->setCacheBackend($cache_backend, 'backend_plugin');
  }

  /**
   * @inheritdoc
   */
  public function getFallbackPluginId($plugin_id, array $configuration = []) {
    return 'null_backend';
  }
}
