<?php

namespace Drupal\matone_vacancy;

/**
 * Interface ImporterInterface
 *
 * Base definitions for the importers.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
interface ImporterInterface {

  /**
   * Get the result.
   *
   * @return ResultInterface
   */
  public function getResult();

  /**
   * Import data.
   *
   * @param array $data
   *
   * @return ResultInterface
   */
  public function import(array $data);
}
