<?php

namespace Drupal\matone_vacancy\Plugin\Mapping;

use Drupal\matone_vacancy\Plugin\MappingBase;

/**
 * @Mapping(
 *   id = "geofield_mapping"
 * )
 */
class GeoFieldMapping extends MappingBase {

  /**
   * @inheritdoc
   */
  public function map($data) {
    if (!isset($data['latlon'])) {
      return '';
    }
    return [
      'value' => "MULTIPOINT ({$data['latlon']})",
    ];
  }
}
