<?php

namespace Drupal\matone_vacancy;

/**
 * Trait FieldMapping
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 * @see \Drupal\matone_vacancy\Importer\Mapper::map
 */
trait FieldMapping
{
    /**
     * @var array
     */
    protected $fields = [];

    /**
     * Add a field to the field mapping.
     *
     * @param string $entity_field
     *     The field the data should be mapped to for the entity. Ex field_vacancy_id
     * @param array  $object_fields
     *     The object fields, the fields in the vacancy object that should get mapped.
     *     Possible to give multiple fields if needed. Values should be snake case, the mapper automatically resolves the
     *     correct functions that should be called.
     *     Ex: ['function_title']
     * @param string $mapping
     *     The id of the mapper plugin required to map the object fields to entity field.
     *     Ex: 'plain_mapping'
     *
     * @return FieldMapping
     */
    public function addField($entity_field, $object_fields, $mapping) {
        $this->fields[$entity_field] = ['fields' => $object_fields, 'mapper' => $mapping];
        return $this;
    }

    /**
     * Return the fields to an array the mapper can work with.
     *
     * @return array
     */
    public function fieldsToArray() {
        return $this->fields;
    }
}
