<?php

namespace Drupal\matone_vacancy\Plugin\Mapping;

use Drupal\matone_vacancy\Plugin\MappingBase;

/**
 * @Mapping(
 *   id = "textfield_mapping"
 * )
 */
class TextfieldMapping extends MappingBase {

  /**
   * @inheritdoc
   */
  public function map($data) {
    if (!$data) {
      return '';
    }

    return [
      'value' => check_markup(html_entity_decode($data), 'rich_text'),
      'format' => 'rich_text'
    ];
  }
}
