<?php

namespace Drupal\matone_vacancy;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface MappingInterface
 *
 * A mapper that maps data from one set to the Drupal implementation.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
interface MappingInterface extends ConfigurableInterface, PluginInspectionInterface {

  /**
   * Maps the given data into a new format.
   *
   * @param $data
   *
   * @return mixed
   */
  public function map($data);
}
