<?php

namespace Drupal\matone_vacancy\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\matone_vacancy\Annotation\Mapping;
use Drupal\matone_vacancy\MappingInterface;

/**
 * Class MappingPluginManager
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class MappingPluginManager extends DefaultPluginManager {

  /**
   * Constructor.
   *
   * @param \Traversable           $namespaces
   * @param CacheBackendInterface  $cache_backend
   * @param ModuleHandlerInterface $module_handler
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/Mapping', $namespaces, $module_handler, MappingInterface::class, Mapping::class);

    $this->alterInfo('mapping_info');
    $this->setCacheBackend($cache_backend, 'mapping_plugin');
  }
}
