<?php

namespace Drupal\matone_vacancy\Importer\Operation;

use Drupal\matone_vacancy\Importer\Mapper;
use Drupal\matone_vacancy\PipeInterface;

/**
 * Class MapOperation
 *
 * Run the data through the mapper.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class MapOperation implements PipeInterface {

  /**
   * @var Mapper
   */
  protected $mapper;

  /**
   * Constructor.
   *
   * @param Mapper $mapper
   */
  public function __construct(Mapper $mapper) {
    $this->mapper = $mapper;
  }

  /**
   * @inheritdoc
   */
  public function handle($data, \Closure $next) {
    $failed_items = $data['result']->getFailed();
    foreach ($data['data'] as $index => $vacancy) {
      try {
        $data['data'][$index] = $this->mapper->map($vacancy);
      } catch (\Exception $e) {
        $failed_items[] = $vacancy;
        unset($data['data'][$index]);
      }
    }
    $data['result']->setFailed($failed_items);
    return $next($data);
  }
}
