<?php

namespace Drupal\matone_vacancy\Plugin\Mapping;

use Drupal\matone_vacancy\Plugin\MappingBase;

/**
 * @Mapping(
 *   id = "date_mapping"
 * )
 */
class DateMapping extends MappingBase {

  /**
   * @inheritdoc
   */
  public function map($data) {
    $date = $data;
    if (preg_match('/\d{10}/', $date)) {
      $date = '@' . $date;
    }

    try {
      $datetime = new \DateTime($date);
      return $datetime->format('Y-m-d');
    } catch (\Exception $e) {
      return NULL;
    }
  }
}
