<?php

namespace Drupal\matone_vacancy\Importer\Operation;

use Drupal\Core\Entity\EntityStorageException;
use Drupal\matone_vacancy\PipeInterface;
use Drupal\matone_vacancy\ResultInterface;
use Drupal\node\Entity\Node;

/**
 * Class CreateOperation
 *
 * Create nodes.
 *
 * @author Sander Boelhouwers <sander.boelhouwers@ara.nl>
 */
class CreateOperation implements PipeInterface {

  /**
   * @inheritdoc
   */
  public function handle($data, \Closure $next) {
    $create_data = $data['data']['create'];

    /** @var ResultInterface $result */
    $result = $data['result'];

    $failed = $result->getFailed();
    $created = $result->getCreated();

    foreach ($create_data as $vacancy) {
      $node = Node::create($vacancy);
      try {
        $node->save();
        $created[] = $node;
      } catch (EntityStorageException $e) {
        $failed[] = [$e, $vacancy];
      }
    }

    $result->setFailed($failed)
      ->setCreated($created);

    return $next($data);
  }
}
